/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.calendar;

import java.util.List;
import java.util.Objects;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.GameRuleChangeEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="tfc")
public class CalendarEventHandler {
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            CalendarTFC.INSTANCE.onServerTick();
        }
    }

    @SubscribeEvent
    public static void onOverworldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.world.field_73011_w.getDimension() == 0) {
            CalendarTFC.INSTANCE.onOverworldTick(event.world);
        }
    }

    @SubscribeEvent
    public static void onCommandFire(CommandEvent event) {
        if ("time".equals(event.getCommand().func_71517_b())) {
            event.setCanceled(true);
            event.getSender().func_145747_a((ITextComponent)new TextComponentTranslation("tfc.command.time.disabled", new Object[0]));
        }
    }

    @SubscribeEvent
    public static void onPlayerWakeUp(PlayerWakeUpEvent event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K && !event.updateWorld()) {
            long currentWorldTime = event.getEntity().func_130014_f_().func_72820_D();
            if (CalendarTFC.CALENDAR_TIME.getWorldTime() != currentWorldTime) {
                long jump = CalendarTFC.INSTANCE.setTimeFromWorldTime(currentWorldTime);
                event.getEntity().func_130014_f_().func_175644_a(EntityPlayer.class, Objects::nonNull).forEach(player -> player.func_71020_j(0.0013333333f * (float)jump / 0.4f * (float)ConfigTFC.General.PLAYER.passiveExhaustionMultiplier));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server;
        if (event.player instanceof EntityPlayerMP && (server = event.player.func_184102_h()) != null) {
            TerraFirmaCraft.getLog().info("Player Logged Out - Checking for Calendar Updates.");
            List players = server.func_184103_al().func_181057_v();
            int playerCount = players.size();
            if (players.contains(event.player)) {
                --playerCount;
            }
            CalendarTFC.INSTANCE.setPlayersLoggedOn(playerCount > 0);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        MinecraftServer server;
        if (event.player instanceof EntityPlayerMP && (server = event.player.func_184102_h()) != null) {
            TerraFirmaCraft.getLog().info("Player Logged In - Checking for Calendar Updates.");
            int players = server.func_184103_al().func_181057_v().size();
            CalendarTFC.INSTANCE.setPlayersLoggedOn(players > 0);
        }
    }

    @SubscribeEvent
    public static void onGameRuleChange(GameRuleChangeEvent event) {
        if ("doDaylightCycle".equals(event.getRuleName())) {
            CalendarTFC.INSTANCE.setDoDaylightCycle();
        }
    }
}

